<div id="printable-container">
	<div class="app-page-title">
   <div class="page-title-wrapper">
        <div class="page-title-heading">
            <div class="page-title-icon">
                <i class="pe-7s-notebook text-success"></i>
            </div>
                <?php echo l('Sales Report', true); ?>
        </div>
    </div>
</div>

<div class="main-card card">
    <div class="card-body">
	<div class="panel panel-default hidden-print">
		<div class="panel-body">
			<div class="h4 form-inline hidden-print">
				<div class="form-group">
			  		<?php echo l('from'); ?>:
					<input type="text" class="form-control datepicker" name="date_start" value="<?php echo $start_date; ?>" style="width: 100px;"/>
					<?php echo l('to'); ?>:
					<input type="text" class="form-control datepicker" name="date_end" value="<?php echo $end_date; ?>" style="width: 100px;"/>
					<select class="form-control" name="report_type" id="report_type">
                        <option value="room" <?=$report_type == 'room' ? 'selected' : ''?> >
							<?php echo l('Room'); ?>
						</option>
                        <option value="room_type" <?=$report_type == 'room_type' ? 'selected' : ''?> >
							<?php echo l('Room').' '.l('Type'); ?> 
						</option>
					</select>
                    <select class="form-control" name="room_type" id="room_type" style="<?=$report_type == 'room_type' ? '' : 'display:none;'?>">
                        <option value="">
                            <?php echo l('All'); ?>
                        </option>
                        <?php foreach($room_types as $room_type){?>
                        <option value="<?= $room_type['id']?>" <?=$rm_type == $room_type['id'] ? 'selected' : ''?> >
                            <?= $room_type['name']?>
                        </option>
                        <?php } ?>
                    </select>
					<button id="generateSalesReport" class="btn btn-success hidden-print"><?php echo l('generate_report'); ?></button>
				</div> <!-- /.form-group -->
				<button id="printReportButton" class="btn btn-primary pull-right hidden-print"><span class="glyphicon glyphicon-print" title="Print Report"></span></button>
                <?php $start_date = ($this->uri->segment(4) != '') ? $this->uri->segment(4) : ""; ?>    
                <?php $end_date = ($this->uri->segment(5) != '') ? $this->uri->segment(5) : ""; ?>    
                <?php $report_type = ($this->uri->segment(6) != '') ? $this->uri->segment(6) : ""; ?>    
                <?php $room_id = ($this->uri->segment(7) != '') ? $this->uri->segment(7) : ""; ?>    
                <?php $param = $start_date."/".$end_date."/".$report_type."/".$room_id;  ?> 
                <a style="margin: 0 10px;" href="<?php if($param != '///'){ echo base_url()."reports/download_sales_csv_export/".$param; } else { echo base_url()."reports/download_sales_csv_export/"; } ?>" class="btn btn-primary pull-right ">
                    <span title="Export to CSV" class="glyphicon glyphicon-download-alt"></span>
                </a>
			</div><!-- /.form-inline -->
		</div>
	</div>
    <div>
<!--        <div class="h3 col-lg-4"><?=$hotel_name;?></div>-->
        <div class="h3 col-lg-8" style="font-size: 20px;">
            <span class="visible-print">
                <b>Reporting Period </b>: <?=date('M d, Y', strtotime($start_date));?> – <?=date('M d, Y', strtotime($end_date));?>
            </span>
            <span class="visible-print"><b>Report Date</b> : <?=date('M d, Y', strtotime(date('Y-m-d')));?></span>
        </div>
    </div>
    <table class="table table-sales-report table-bordered text-center">
        <tr class="table-title">
            <th colspan="4" class="text-center"><?php echo l('Room', true); ?></th>
			<th colspan="3" class="text-center"><?php echo l('Bookings', true); ?></th>
            <th colspan="6" class="text-center"><?php echo l('Net Revenue', true); ?></th>
			<th colspan="4" class="text-center"><?php echo l('Statistics', true); ?></th>
        </tr>
        <tr class="table-title">
            <th colspan="2" class="text-center"><?php echo l('Name', true); ?></th>
            <th colspan="2" class="text-center"><?php echo l('Description', true); ?></th>
            <th colspan="1" class="text-center"><?php echo l('Res', true); ?></th>
            <th colspan="1" class="text-center">%</th>
            <th colspan="1" class="text-center"><?php echo l('Nights', true); ?></th>
            <th colspan="1" class="text-center"><?php echo l('Room', true); ?></th>
            <th colspan="1" class="text-center"><?php echo l('Other', true); ?></th>
            <th colspan="1" class="text-center"><?php echo l('Tax', true); ?></th>
            <th colspan="1" class="text-center"><?php echo l('Total(with taxes)', true); ?></th>
            <th colspan="1" class="text-center"><?php echo l('Payment', true); ?></th>
            <th colspan="1" class="text-center"><?php echo l('Balance', true); ?></th>
            <th colspan="1" class="text-center"><?php echo l('Cancel', true); ?> %</th>
            <th colspan="1" class="text-center"><?php echo l('Avg Stay', true); ?></th>
            <th colspan="1" class="text-center"><?php echo l('ADR', true); ?></th>
            <th colspan="1" class="text-center"><?php echo l('Rev PAR', true); ?></th>
        </tr>
		<tbody>
            <?php 
            $total = array();
            $total['booking_count'] = $total['total_nights'] = $total['avg_stay'] = $total['occupancy_rate'] = $total['room_charge_total'] = $total['other_charge_total'] =  $total['tax_total'] = $total['charge_total_with_tax'] = $total['cancelled_booking_per'] = $total['ADR'] = $total['revPAR'] = $total['payment_total'] = $total['balance'] = 0;
            foreach($daily_data as $key => $data) {?>
                <tr class="table-title">
                    <td colspan="2"><?=$data['room_name']?></td>
                    <td colspan="2"><?=$data['room_type_name']?></td>
                    <td colspan="1"><?=$data['booking_count']?></td>
                    <td colspan="1"><?=number_format($data['occupancy_rate'], 2, ".", ",")?>%</td>
                    <td colspan="1"><?=$data['total_nights']?></td>
                    <td colspan="1"><?=number_format($data['room_charge_total'], 2, ".", ",");?></td>
                    <td colspan="1"><?=number_format($data['charge_total'] - $data['room_charge_total'], 2, ".", ",");?></td>
                    <td colspan="1"><?=number_format($data['charge_total_with_tax'] - $data['charge_total'], 2, ".", ",");?></td>
                    <td colspan="1"><?=number_format($data['charge_total_with_tax'], 2, ".", ",");?></td>
                    <td colspan="1"><?=number_format($data['payment_total'], 2, ".", ",");?></td>
                    <td colspan="1"><?=number_format($data['charge_total_with_tax'] - $data['payment_total'], 2, ".", ",");?></td>
                    <td colspan="1"><?=number_format($data['cancelled_booking_per'], 2, ".", ",")?>%</td>
                    <td colspan="1"><?=$data['avg_stay']?></td>
                    <td colspan="1"><?=number_format($data['ADR'], 2, ".", ",")?></td>
                    <td colspan="1"><?=number_format($data['revPAR'], 2, ".", ",")?></td>
                </tr>
            <?php 
                $total['booking_count'] += $data['booking_count'];
                $total['occupancy_rate'] += $data['occupancy_rate'];
                $total['total_nights'] += $data['total_nights'];
                $total['room_charge_total'] += $data['room_charge_total'];
                $total['other_charge_total'] += $data['charge_total'] - $data['room_charge_total'];
                $total['tax_total'] += $data['charge_total_with_tax'] - $data['charge_total'];
                $total['charge_total_with_tax'] += $data['charge_total_with_tax'];
                $total['payment_total'] += $data['payment_total'];
                $total['balance'] += ($data['charge_total_with_tax'] - $data['payment_total']);
                $total['cancelled_booking_per'] += $data['cancelled_booking_per'];
                $total['avg_stay'] += $data['avg_stay'];
                $total['ADR'] += $data['ADR'];
                $total['revPAR'] += $data['revPAR'];
            } 
			$row_count = count($daily_data);
			$datediff = strtotime($end_date) - strtotime($start_date);
			$range_days = round($datediff / (60 * 60 * 24)) + 1;
			//$total['ADR'] = $total['booking_count'] > 0 ? $total['room_charge_total'] / $total['booking_count'] : 0;
			$total['ADR'] = $total['total_nights'] > 0 ? $total['room_charge_total'] / $total['total_nights'] : 0;
			//$total['revPAR'] = $number_of_rooms > 0 ? $total['room_charge_total'] / $number_of_rooms : 0;
			//$total['ADR'] = $row_count > 0 ? $total['ADR'] / $row_count : 0;
			$total['revPAR'] = $row_count > 0 ? $total['revPAR'] / $range_days : 0;
			$total['avg_stay'] = intval($row_count > 0 ? $total['avg_stay'] / $row_count : 0);
			$total['cancelled_booking_per'] = $row_count > 0 ? $total['cancelled_booking_per'] / $row_count : 0;
            $total['occupancy_rate'] = $total['occupancy_rate'] > 0 ? $total['occupancy_rate'] / $row_count : 0;
			?>
                <tr class="table-title">
                    <td colspan="4" class="text-right"><?php echo l('Totals', true); ?>:</td>
                    <td colspan="1"><?=$total['booking_count']?></td>
                    <td colspan="1"><?=number_format($total['occupancy_rate'], 2, ".", ",")?>%</td>
                    <td colspan="1"><?=$total['total_nights']?></td>
                    <td colspan="1"><?=number_format($total['room_charge_total'], 2, ".", ",");?></td>
                    <td colspan="1"><?=number_format($total['other_charge_total'], 2, ".", ",");?></td>
                    <td colspan="1"><?=number_format($total['tax_total'], 2, ".", ",");?></td>
                    <td colspan="1"><?=number_format($total['charge_total_with_tax'], 2, ".", ",");?></td>
                    <td colspan="1"><?=number_format($total['payment_total'], 2, ".", ",");?></td>
                    <td colspan="1"><?=number_format($total['balance'], 2, ".", ",");?></td>
                    <td colspan="1"><?=number_format($total['cancelled_booking_per'], 2, ".", ",")?>%</td>
                    <td colspan="1"><?=$total['avg_stay']?></td>
                    <td colspan="1"><?=number_format($total['ADR'], 2, ".", ",")?></td>
                    <td colspan="1"><?=number_format($total['revPAR'], 2, ".", ",")?></td>
                </tr>
		</tbody>
	</table>
</div>
</div>
</div>